//
//	Class definition for Test Dialog class
//

#ifndef THE_OPTIONS_DIALOG_H
#define THE_OPTIONS_DIALOG_H

#include "ldwTiledDialog.h"
#include "ldwImage.h"
#include "ldwGameWindow.h"
#include "../Effects/FloatingAnim.h"
#include "../Game/theGameState.h"
#include "../Game/theRealtimeManager.h"
#include "../Utils/theStringManager.h"
#include "../Game/Isola.h"

class ldwButton;
class ldwImageGrid;
//class ldwSoundTrack;
//class ldwSoundFx;
typedef struct  
{
	bool soundOn;
	bool fullscreen;
	int difficulty;
	int gameSpeed;
	float soundVol;
	float musicVol;
	float voiceoverVol;
}OptionsDataStruct;

typedef enum
{
	eOptGreenCanvas,
	eOptRedCanvas,
	eOptOrangeCanvas,
	eOptNoColor
} OptDialogColorEnum;	

class theOptionsDialog : public ldwTiledDialog
{
public:

	theOptionsDialog(char *labelA,  DialogColorEnum dialogCanvas);
	~theOptionsDialog();
	
	int  GetResult();

	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);

private:

	ldwRect bounds;

	int popupSize;

	bool showFullscreenOption;

	bool slider1InHand;
	bool slider2InHand;
	bool slider3InHand;
	int slider1X;
	int slider2X;
	int slider3X;

	const int cChoiceAButtonID;

	theGameState * gs;
	//theRealtimeManager *realtimeManager;

	int correctedLeft;
	int centerX;
	int correctedTop;

	ldwImageStrip * checkBox;
	ldwImage * checkBoxChecked;
	ldwImage * radioBtnOff;
	ldwImage * radioBtnOn;
	ldwImage * sliderFrame;
	ldwImage * sliderHandle;

	ldwGameWindow *gameWindow;
	ldwSoundTrack  *soundTrack;
	ldwSoundFx     *soundFx;
	theStringManager *strMgr;

	OptionsDataStruct optionsData;

protected:

	bool paramaterUsed ;

	void DrawNoFadeScene();

	ldwButton      *choiceAButton;

	int  mResult;
};

#endif
